// 
//  FJDIndexedItem.m
//  FJDIndexedItemsWindow
//
//  Created by FUJIDANA on 06/08/22.
//  Copyright 2006 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "FJDIndexedItem.h"


@implementation FJDIndexedItem 


- (NSNumber *)index 
{
	NSNumber *tmpValue;
	
	[self willAccessValueForKey:@"index"];
	tmpValue = [self primitiveValueForKey:@"index"];
	[self didAccessValueForKey:@"index"];
	
	return tmpValue;
}

- (void)setIndex:(NSNumber *)value 
{
	[self willChangeValueForKey:@"index"];
	[self setPrimitiveValue: value forKey:@"index"];
	[self didChangeValueForKey:@"index"];
}

- (BOOL)validateIndex:(id *)valueRef error:(NSError **)outError 
{
 	if (*valueRef == nil) {
		return YES;
	}
	
	NSMutableSet *itemsSet = [[self valueForKeyPath:@"indexManager.items"] mutableCopy];
	[itemsSet removeObject:self];
	NSSet *indexesSet = [itemsSet valueForKey:@"index"];
	[itemsSet release];
	
	if ([indexesSet containsObject:*valueRef]) {
		
		// In case duplicated index is found...
		
		if (outError != NULL) {
			NSString *desciption = NSLocalizedStringFromTable(@"Index is duplicated.", @"CoreDataLocalizable", @"validation.duplicatedIndex");
            NSDictionary *userInfoDict = [NSDictionary dictionaryWithObjectsAndKeys:
				desciption, NSLocalizedDescriptionKey,
				@"index", NSValidationKeyErrorKey,
				*valueRef, NSValidationValueErrorKey,
				self, NSValidationObjectErrorKey,
				nil];
			NSError *error = [[[NSError alloc] initWithDomain:NSCocoaErrorDomain
														code:NSManagedObjectValidationError
													userInfo:userInfoDict] autorelease];
			*outError = error;
		}
		return NO;
	}
    return YES;
}


- (NSManagedObject *)indexManager 
{
	id tmpObject;
	
	[self willAccessValueForKey:@"indexManager"];
	tmpObject = [self primitiveValueForKey:@"indexManager"];
	[self didAccessValueForKey:@"indexManager"];
	
	return tmpObject;
}

- (void)setIndexManager:(NSManagedObject *)value 
{
	[self willChangeValueForKey:@"indexManager"];
	[self setPrimitiveValue:value
					 forKey:@"indexManager"];
	[self didChangeValueForKey:@"indexManager"];
}


- (BOOL)validateIndexManager:(id *)valueRef error:(NSError **)outError 
{
	// Insert custom validation logic here.
	return YES;
}

@end
